--5/2/2007 fixed names with | character. -GT

spool wqx_chartype_assignments.log

set define off;

create unique index ui_char_chartype on characteristic_chartype (fk_characteristic,fk_chartype)
tablespace storetindx
storage (initial 3M next 3M);
set feedback on
set echo off;
prompt Count of characteristic_chartype;
select count(*) from characteristic_chartype;

prompt OVERALL characteristics without chartype assignment


select count(*) from di_characteristic c
where not exists (select 1 from characteristic_chartype cc
    where cc.fk_characteristic = c.pk_isn);

prompt WQX characteristics without chartype assignment
select count(*) from di_characteristic c
where not exists (select 1 from characteristic_chartype cc
    where cc.fk_characteristic = c.pk_isn)
and pk_isn >= 1000000;

set feedback off;
set echo off;
set echo on;


insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='(-)-cis-Permethrin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='(-)-trans-Permethrin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='(+)-cis-Permethrin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='(2-Methyl-1-propenyl)benzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='(3-Bromopropyl)benzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='(E)-6-Methyl-3-undecene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='(E,E)-Farnesol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='(Z)-Chloro-1-propene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='(Z,Z)-11,13-Hexadecadienal';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.alpha.,.alpha.-Dimethylphenethylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.alpha.-Amino-2,3-dihydro-5-methyl-3-oxo-4-isoxazolepropanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.alpha.-Chlordene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.alpha.-Endosulfan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.alpha.-Hexachlorocyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.alpha.-Methylstyrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.alpha.-Naphthylthiourea';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.alpha.-Nitrotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.alpha.-Terpineol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.beta.-Chlordene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.beta.-Endosulfan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.beta.-Hexachlorocyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.delta.-Hexachlorocyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='.gamma.-Butyrolactone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='.gamma.-Chlordene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,1,2-Tetrachloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,1-Trichloro-2-propanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,1-Trichloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,1-trichloropentane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,1-Trichloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,2,2-Tetrabromoethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,1,2,2-Tetrachloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,2-Trichloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,3-Trimethyl-3-(2-methallyl)cyclopentane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,4,6-Tetramethylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1,4,7-Tetramethylindan';

--insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
-- select pk_isn,7 from di_characteristic c
-- where c.display_name='1,1''||''''''''||''-Binaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name= '1,1''-Binaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dichloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dichloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dichloropropanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dichloropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dimethoxyethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dimethyl-2-octylcyclobutane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dimethylcyclopropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1-Dimethylindan';

--insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
-- select pk_isn,7 from di_characteristic c
-- where c.display_name='1,1''||''''''''||''-Oxybis[3-chloropropane]';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,1''-Oxybis[3-chloropropane]';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,2,3,4,5,6-Hexachlorocyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,5,7,7-Heptachloro-2-norbornene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,6,7,8,9-Octachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,6,7,8,9-Octachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,6,7,8-Heptachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,6,7,8-Heptachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,7,7-Hexachloronorbornadiene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,7,8,9-Heptachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,7,8-Hexachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4,7,8-Hexachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4-Tetrachlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4-Tetrahydronaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4-Tetramethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,4-Tetramethylphenanthrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,5-Tetrachlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,5-Tetramethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,6,7,8-Hexachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,6,7,8-Hexachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,7,8,9-Hexachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,7,8,9-Hexachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,7,8-Pentachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3,7,8-Pentachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3-Trichlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3-Trichloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,3-Trimethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,4,5-Tetrachlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2,4-Trimethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Benzisothiazole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Bis(2-chloroethoxy)ethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Butylene oxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,2-Dibromo-3-chloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Dichlorobutane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,2-Dichloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Dichloroethylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,2-Dichloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Dichloropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Dimethyl-3-ethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Dimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Diphenylhydrazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Epithiocyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,2-Propadienylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3,5-Triazine-2,4-diamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3,5-Trichlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3,5-Trimethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3,5-Trinitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3-Butadiene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3-Dichloro-2-propanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,3-Dichloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,3-Dichloropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3-Dimethyl-4-ethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3-Dimethyl-5-ethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3-Dimethylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,3-Dioxolane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,4-Dichloro-2-butene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,4-Dichloro-2-butyne';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,4-Dichlorobutane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,4-Dimethoxyanthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1,4-Dimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,4-Dioxane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,4-Naphthoquinone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,6,7-Trimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,6-Dimethylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,6-Dimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,8-Naphthalic anhydride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1,9-Nonanediol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='11-Tricosene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Bromo-2-chloroethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='1-Bromo-3-chloro-5,5-dimethyl-2,4-imidazolidinedione';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Butanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chloro-2,2-dimethylpropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chloroanthraquinone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chlorobutane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chlorocyclohexene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chlorohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chloronaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Chloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Decanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Eicosanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Heptadecanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Hexadecanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Hexanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1H-Inden-1-one, 2,3-dihydro-3,3-dimethyl-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Hydroxychlordene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Methoxy-2-butanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Methylfluorene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Methylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Methylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Methylphenanthrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Methylpyrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Naphthalenamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Naphthol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Pentene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='1-Phenylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Propanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='1-Tetradecanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-(Methylthio)benzothiazole';

--insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
-- select pk_isn,8 from di_characteristic c
-- where c.display_name='2,2''||''''''''||'',3,3''||''''''''||'',4,4''||''''''''||'',5,5''||''''''''||'',6-Nonachlorobiphe
nyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',5,5'',6-Nonachlorobiphenyl' ;

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',5,5''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',5,6,6''-Nonachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',5,6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',5,6-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',5-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',6,6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,4''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,5'',6,6''-Nonachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,5'',6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,5'',6-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,5''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5'',6,6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,6,6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5'',6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5,6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,5-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,6,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',4-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5,5'',6,6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5,5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5,6,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',6,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,3''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5,5'',6-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5,5''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5,6,6''-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5,6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',5-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',6,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,4''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5,5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5,5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5,6,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5,6,6''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',6,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,6,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',6''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,6''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4,6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,4-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5,5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5,6,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5,6''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5,6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,6,6''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,6''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3,6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',3-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,4'',5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,4'',5,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,4'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,4'',6,6''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,4'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,4''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,5,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,2,4,5,6,7,8,8-Octachloro-2,3,3a,4,7,7a-hexahydro-4,7-methano-1H-indene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,5'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,5,6''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,6,6''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,6''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4,6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',4-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',5,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',5,6''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',6,6''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2'',6-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,2,6-Trimethylcyclohexanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,2''-Biquinoline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,2-Dibromo-3-nitrilopropionamide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,2''-Dichlorobenzophenone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,2''-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,2-Dichloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,2-Dimethylpropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3 Dimethyloctane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',5,5'',6-Octachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',5,5''-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',5,6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',5-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,4''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',5,5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,5,5'',6-Heptachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',5,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,5,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4,6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',4-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',5,5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',5,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',5'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',5,6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3'',6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,3''-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,4'',5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,4'',5'',6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,4'',5,6-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,4'',5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,4'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,4'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,4'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,4'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,4''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,4''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4'',5,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,5,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4'',5'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,5'',6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4'',5,6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,5,6-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4'',5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4'',5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4'',5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,4,5-Tetrachlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,4,6,7,8-Hexachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,4,6,7-Pentachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4'',6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4,6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4'',6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4,6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,4,6-Tetrachlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,4,7,8-Pentachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4''-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',4-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4''-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,4-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',5,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',5'',6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,5,6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,5,6-Tetrachlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',5''-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3'',6-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3,6-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,6-Trichlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,6-Trimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,7,8-Tetrachlorodibenzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3,7,8-Tetrachlorodibenzo-p-dioxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3''-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,3-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,3-Dichloropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4,4'',5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4,4'',6-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4,4''-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4,5-T';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4,5-T isooctyl ester';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4,5-T isopropyl ester';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4,5-TB';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4'',5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4,5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4,5-Trichlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4,5-Trichlorophenoxypropanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4,5-Trimethylbenzoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4,6-Tribromophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4'',6-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4,6-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4,6-Trichlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4,6-Trimethylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4,6-Tris(tert-butyl)phenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4-D';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4-D isobutyl ester';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2,4-DB';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4''-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,4-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4-Dichloronitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4-Dinitrophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,4-Toluenediamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,5-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,5-Diethyltetrahydrofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,5-Dimethylfuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6,10,15,19,23-Hexamethyl-2,6,10,14,18,22-tetracosahexaene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Dichloro-4-methylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2,6-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Dichlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Dichlorotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Diethylaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Dimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Dinitro-p-cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,6-Di-tert-butyl-p-cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2,7-Dimethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Amino-4,6-dinitrotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Bromo-1-chloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Butanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Butoxy-2-oxoethyl butyl phthalate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Butyloctanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chloro-1-phenylethanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chloro-4,6-diamino-s-triazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2-Chloro-4-isopropylamino-6-amino-s-triazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chlorobenzothiazole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='2-Chlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chloroethanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chloronaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chloropropane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Chlorosyringaldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2-Choro-6-ethylamino-4-amino-s-triazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Cyclohexen-1-one';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Cyclohexylidenecyclohexanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2-Ethoxyethanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethyl-2-methyl-1,3-dioxolane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethylhexanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethylhexanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethylhexyl diphenyl phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethyl-m-xylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Ethyl-p-xylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Fluoro-4-nitrophenol potassium salt';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Fluorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Hexanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methyl-2-butanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methyl-3-butyn-2-ol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methyl-5-nitroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylanthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylbutanal';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylbutane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylcyclopentanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylfuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylhexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylnaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylpentane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Methylpyridine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Naphthalenamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='2-Nitro-1,1-bis(p-chlorophenyl)propane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Pentanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Phenyl-2-propanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Piperidone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-Propen-1-ol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='2-tert-Butylthiophene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4,4'',5,5''-Hexachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4,4'',5-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4,4''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4,5,5''-Pentachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4,5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',4-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',5,5''-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3'',5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,3''-Dichlorobenzidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,3''-Dichlorobenzophenone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,3''-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,3''-Dimethoxybenzidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,3''-Dimethylbenzidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,3-Dimethylhexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,4,4'',5-Tetrachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,4,4''-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,4'',5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,4,5-Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,4-Dichloroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,4''-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,4-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,4-Dichlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,4-Dimethylhexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,4-Dimethylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,5-Dichlorobenzoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3,5-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,5-Dimethylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3,5-Dinitroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Chloro-4-methylaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Chlorobicyclo[3.2.1]oct-2-ene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='3-Chlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Cyclohexene-1-carboxylic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='3-Hydroxycarbofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Methyl-1-indanone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Methylbiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Methylcholanthrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Methylhexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Methylpentane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Methylsalicylic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Pentanol, 3-ethyl-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='3-Phenyldecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='3-Trifluoromethyl-4-nitrophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,4''-Dichlorobenzil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='4,4''-Dichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,4-Dimethyl-1,3-dioxane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,4''-Isopropylidenediphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,4''-Methylenebis(2-chloroaniline)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,5-Dichlorocatechol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,6-Dichloro-o-cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,6-Dimethylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='4,6-Dinitro-o-cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4,7-Dimethylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Amino-2,6-dinitrotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Aminobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Chloro-2-methylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='4-Chlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Dimethylaminoazobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='4-Ethyl-4H-1,2,4-triazole-3-amine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Ethylresorcinol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4H-Cyclopenta[def]phenanthrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Methyl-1,3-dioxolane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Methyl-2-pentanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Methyl-3-nitroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Methyldecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Methylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Phenylbutyric acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='4-Phenylpyridine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='5-Hydroxydicamba';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='5-Methylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='7,12-Dimethylbenz[a]anthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='7-Phenyltetradecane + 6-phenyltridecane mix';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='9-Hexadecenoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='9-Methylanthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='9-Nitroso-9H-carbazole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='9-Octadecenal';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Acephate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Acequincyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Acetic acid, octadecyl ester';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Acetonitrile';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Acetovanillone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Acid Volatile Sulfides';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Acidity, hydrogen ion (H+)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Adenosine triphosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Aflatoxins';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Aldrin + dieldrin mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, all groups, density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, blue-green (phylum cyanophyta) density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, brown (phylum phaeophyta) density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, golden-brown (phylum chrysophyta) density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, green (phylum chlorophyta) density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, red (phylum rhodophyta) density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, substrate rock/bank cover (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Algae, yellow-green (phylum xanthophyta) density';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Alkalinity, bicarbonate as CaCO3';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Alkalinity, carbonate as CaCO3';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Alkalinity, hydroxide as CaCO3';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Alkalinity, total';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Alkane mix C10-C34';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Alkanes, total';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Alpha particle';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Ametryn';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Amitrole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Ammonia';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Amoxicillin trihydrate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Amylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Anatoxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Anion/cation ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Anise oil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Anisole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Anthraquinone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Antimony potassium tartrate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Apparent color';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='ar,ar''-Dimethylbiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor (unspecified)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1016';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1016 mixt. with Aroclor 1221';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1016 mixt. with Aroclor 1242';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1210';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1216';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1221';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1231';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1232';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1240';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1242';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1242 mixt. with Aroclor 1248';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1242 mixt. with Aroclor 1248 and Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1242 mixt. with Aroclor 1254';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1242 mixt. with Aroclor 1254 and Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1242 mixt. with Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1248';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1248 mixt. with Aroclor 1254';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1248 mixt. with Aroclor 1254 and Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1248 mixt. with Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1250';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1252';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1254';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1254 mixt. with Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1260';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1262';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 1268';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Aroclor 5442';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Arsenic ion (3+)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Arsenic ion (5+)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Arsenic(V) pentoxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Azide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Bacteria mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Barium-lanthanum';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Beck Biotic Index';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Benfluralin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Bensulide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Bentazon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benz[a]anthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzal chloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzene, (1-ethyldecyl)-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzene, C6-12-alkyl derivs.';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzene, nonyl-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzene, toluene, ethyl benzene, xylenes mix';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzeneacetonitrile';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzeneethanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzenesulfonic acid, C10-13-alkyl derivs., sodium salts';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzo(b)fluoranthene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzo[c]cinnoline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzo[e]pyrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzo[ghi]perylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Benzofuran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Beta particle';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='BHC, .beta.-BHC & .gamma.-BHC mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Biochemical oxygen demand, non-standard conditions';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Biochemical oxygen demand, standard conditions';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Biomass/chlorophyll ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bio-toxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bis(2-chloro-1-methylethyl) ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bis(2-chloroethoxy)methane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Bis(2-chloroethyl) ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bis(2-chloroisopropyl) ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bis(2-hydroxypropyl) ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='bis(3-Methylcyclohexyl) peroxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bis(4-chlorophenyl)methane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bis(chloromethyl) ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Boric acid esters mixture, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Brillouin Taxonomic Diversity Index';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bromoacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bromobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bromochloroacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Bromochloroiodomethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Bulan mixt. with 2-nitro-1,1-bis(p-chlorophenyl)propane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Butyl benzoate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Butylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Butyltin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Butyltin trichloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Butyric acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C10 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C10-16-Alkyldimethylamines oxides';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C12 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C14 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C16 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C18 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C1-C3 Fluorenes';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C1-C4 Chrysenes';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C1-C4 Fluoranthenes';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C1-C4 Phenanthrenes';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C20 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C22 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C24 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C26 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C28 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C29 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C30 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C31 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C32 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C33 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C34 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C35 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='C8 Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Carbaryl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Carbon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Carbonaceous biochemical oxygen demand, non-standard conditions';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Carbonaceous biochemical oxygen demand, standard conditions';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Carbonate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Carbophenothion';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Carbophenothion-methyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Catechol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='CFC-11';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='CFC-113';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='CFC-113a';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='CFC-12';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Chemical oxygen demand';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chloramben-methyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlordecone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlorfenson';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chlorinated naphthalenes';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chloroacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chloroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chloromethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chloronaphthalene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chlorophyll';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chlorophyll a';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chlorophyll b';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chlorophyll c';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlorothalonil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlorpyrifos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlorsulfuron';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chlortetracycline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlorthal-dimethyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Chlorthion';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Chromium(III)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Chromium(VI)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Chrysotile asbestos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='cis-1,2-Dichloroethylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='cis-1,3-Dimethylcyclopentane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='cis-1-Bromo-2-chlorocyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='cis-2-Bromocyclohexanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='cis-2-Phenyl-2-butene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='cis-Captafol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='cis-Chlordane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='cis-Nonachlor';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Clomazone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Clonitralid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Coliform/Streptococcus ratio, fecal';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Colored dissolved organic matter (CDOM)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Corrosion & scaling control, Ryznar Stability Index';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Creosote';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Cyanides amenable to chlorination (HCN & CN)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Cyclohexylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Cyclonite';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Cyclotetramethylenetetranitramine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Cypermethrin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Dalapon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Decachlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Decanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Decylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Demeton-methyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Demeton-O';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Demeton-S';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Deoxygenation constant-carbon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Deoxygenation constant-nitrogen';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Depth, from ground surface to well water level';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Depth, Secchi disk depth';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Depth, Secchi disk depth (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dextronorgestrel (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='D-Gluconic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='D-gluconic acid sodium salt';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Di(2-ethylhexyl) adipate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Di(2-ethylhexyl) phthalate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibenz[a,h]anthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibenz[a,j]acridine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibenzo[b,k]fluoranthene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibenzothiophene (C1-C3)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibromoacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibutyl azelate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibutyl terephthalate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dibutyltin dichloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dichloroacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dichlorobutane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dichlorobutene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Dichloroethylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dichloropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Dichlorvos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diclofop methyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diethatyl ethyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diethyl sulfide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diethylene glycol monobutyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diethylene glycol monobutyl ether acetate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diethylene glycol monomethyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diethylstilbestrol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diflufenzopyr';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diflufenzopyr-sodium';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diisopropyl adipate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethyl L-malate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethyl sulfoxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethyl terephthalate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethylacetamide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethylphenanthrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethylstyrene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dimethylvinyl chloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Di-n-octyl phthalate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Dinoseb';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dioctyl adipate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dioxin + furan mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diphenyl disulfide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diphenylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Diphenylsulfone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dipropyl sulfide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diquat';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Diquat dibromide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Dissolved inorganic nitrogen/soluble reactive phosphorus ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Disulfoton sulfone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Di-tert-butyl ketone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Divinylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Docosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dodecylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dotriacontane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='d-trans-Allethrin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Dyphylline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Eicosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Endosulfan sulfate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Endrin aldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Enterococcus';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Erythromycin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethane, isothiocyanato-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethanol-d';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethanone, 1-(2,5-dichlorophenyl)-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Ethoxylated abietylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethoxylated dehydroabietylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethoxylated rosin acids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Ethyl mercaptan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Ethylan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Ethylene dibromide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Ethylene glycol monobutyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethylene glycol monoethyl ether acetate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethylene thiourea';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethylenediaminetetraacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Ethyltoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Eucalyptol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Ferric ion';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Ferrous ion';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='FireMaster BP 6';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fish condition factor';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fish fork length';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fish kill observation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fish Kill, Severity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fish standard length';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fixed disolved solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Fixed suspended solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Floating algae mat - severity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Floating Detergent/Soap - Severity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Floating Garbage Severity (choice List)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Floating sludge - severity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Fluazifop-P-butyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Flucythrinate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fluoranthenes + pyrenes mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fluoride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fluoroboric acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fluorotrimethylsilane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fluoxetine hydrochloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Fluvalinate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Formetanate hydrochloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Fosamine-ammonium';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Free mineral acidity (FMA)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fuel oil no. 1';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Fuel oil no. 2';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='General observation (text)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='General pathology (text)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Glycine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Glyphosate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Gran acid neutralizing capacity';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Guaiacol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Halides';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Haloacetic acids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Halogenated organics';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Halon 1011';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Hardness, Ca, Mg';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Hardness, magnesium';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='HCFC-123';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='HCFC-21';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='HCFC-22';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='HCFC-31';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Height';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Helleborein';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Heneicosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hentriacontane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Heptachloro-2-norbornene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Heptacosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Heptadecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Heptanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Heptene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Herbicide mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Heterotrophic bacteria';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hexachlorobenzine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hexachloropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hexacosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hexadecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hexafluoropropene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hexasulfur';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='HFC-152a';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hydrocarbons, petroleum';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hydrocinnamic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Hydrogen';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Hydrograph limb (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Imazalil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Indan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Inorganic carbon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,3 from di_characteristic c
 where c.display_name='Inorganic monomeric aluminum';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Inorganic nitrogen (nitrate and nitrite)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Iodide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Ionic strength';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Iron + aluminum mix';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Iron + manganese mix';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Isazofos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Isobenzan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Isobutanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Isobutene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Isobutyl benzoate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Isopropanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Isopropyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Isovaleraldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Kjeldhal nitrogen';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Kojic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Lake physical appearance (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Lake recreational suitability (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Lead monoxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Lead(II) chromate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Life stage (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light attenuation coefficient';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, (PAR at depth/PAR at surface) x 100';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, incident';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, incident + reflected (ambient)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, photosynthetic active radiation (PAR)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, photosynthetic active radiation at depth (PAR)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, reflected';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, transmissivity';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, underwater extinction coefficient (K)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, underwater incident';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, underwater incident + reflected';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Light, underwater reflected';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Lindane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Lipids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='L-Proline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Manganese dimethyldithiocarbamate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Maple lactone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Margalef Taxonomic Diversity Index';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='MBAS';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Chloroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Chlorofluorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='m-Chloronitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Chlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Chlorotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='MCPA';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='MCPB';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Dichlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Dinitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Mecoprop';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Medroxyprogesterone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Menadione';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Mesityl oxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='meta & para Xylene mix';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Metaldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methacrylonitrile';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Methiocarb';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl arachidate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl dehydroabietate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl disulfide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl hexanoate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl hydrazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl linoleate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl myristate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl nonyl ketone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl o-benzoylbenzoate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl oleate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl palmitate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Methyl paraoxon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl stearate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl tert-butyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl toluate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methyl trans-crotonate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylanthracene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Methylarsonic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylcyclohexane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylcyclohexane-d14';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylene chloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Methylene dithiocyanate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylindan';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylmercury(1+)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Methylpyridine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Ethyltoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Metiram';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Mevinphos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Mexacarbate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Hydroxybenzoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Mica group minerals';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Microcystin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='MIOX micaceous iron oxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Nitroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Nitrotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Monocrotophos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Motor oil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Musk moskine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='m-Xylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Myclobutanil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Myristic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N,N-Diethylaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N,N-Diethyl-m-toluamide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N,N-Dimethylformamide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N,N-Dimethylstearamide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-2-Ethylhexylbicycloheptenedicarboximide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='n-Amyl acetate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Naphthalene (C1-C4)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='n-Butyl acetate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='n-Butyl lactate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Butylacetanilide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='n-Butylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Neosaxitoxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Nitrate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Nitrite';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nitrogen';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nitrogen plus argon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Nitrogen-15/14 ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Nitrogenous biochemical oxygen demand';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Nitrophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Methyl-2-pyrrolidone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosodiethylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosodimethylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosodi-n-butylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosodi-n-propylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosodiphenylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosomethylethylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosomorpholine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitroso-N-ethylurea';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitroso-N-methylurea';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosonornicotine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosopiperidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='N-Nitrosopyrrolidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nodularin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nonacosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nonadecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nonanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Norethisterone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nortriptyline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='n-Propylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='O-(2,4-Dichlorophenyl) O-methyl isopropylphosphoramidothioate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='O,O-Diethyl dithiophosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='O,O-Dimethyl dithiophosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='o,p''-DDD';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o,p''-DDE';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='o,p''-DDT';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o,p''-Methoxychlor';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Chloroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='o-Chloronitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Chlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Chlorotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='o-Cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Octacosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Octadecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Octane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Octyl decyl phthalate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Octyl diphenyl phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Cymene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Dichlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Odor threshold number';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='O-Ethyl O-(p-nitrophenyl) phenylphosphonothioate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Ethyltoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Fluorophenatole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Fluorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oleandomycin phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Nitroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Nitroanisole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Nitrophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Nitrotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Organic anions';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Organic carbon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Organics mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Organics semivolatile mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Organics volatile mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='ortho & para Xylene mix';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Orthophosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Toluidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Toluidine hydrochloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Vinyltoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxetane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Oxyfluorfen';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxygen';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Oxygen 18/oxygen 16 ratio in sulfate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxygen-18';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxygen-18/Oxygen-16 ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='o-Xylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxytetracycline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxytetracycline calcium';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Oxytetracycline hydrochloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-(1,1,3,3-Tetramethylbutyl)phenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p,p''-DDD';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p,p''-DDE';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p,p''-DDT';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Palmitonitrile';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='P-Aminohippuric acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Paraffin oils';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size (size/range in result Particle Size Basis)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 04, 4 mesh, (4.75mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 05, 5 mesh, (4.00mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 06, 6 mesh, (3.35mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 07, 7 mesh, (2.80mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 08, 8 mesh, (2.36mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 10, 9 mesh, (2.00mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 12, 10 mesh, (1.70mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 14, 12 mesh, (1.40mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 16, 14 mesh, (1.18mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 18, 16 mesh, (1.00mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 20, 20 mesh, (0.850mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 25, 24 mesh, (0.710mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 30, 28 mesh, (0.600mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle Size, Sieve NO. 35, 32 Mesh, (0.425mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 40, 35 mesh, (0.425mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 45, 42 mesh, (0.355mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 50, 48 mesh, (0.300mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 60, 60 mesh, (0.250mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 70, 65 mesh, (0.212mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Particle size, Sieve No. 80, 80 mesh, (0.180mm)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Bromofluorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Bromophenyl phenyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-105/132/153';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-107/124';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-110/115';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-12/13';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-123/149';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-123/153';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-128/166';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-129/138/160/163';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-132/153';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-134/143';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-135/144';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-135/151/154';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-137/176';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-138/160';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-138/163';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-139/140';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-141/179';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-147/149';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-15/17';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-153/168';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-153/173/201';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-156/157';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-16/32';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-17/18';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-170/190';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-171/173';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-171/202';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-172/197';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-18/30';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-180/193';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-182/187';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-183/185';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-195/208';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-196/203';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-197/200';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-198/199';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-20/28';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-20/33';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-21/33';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-22/51';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-24/27';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-26/29';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-28/31';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-37/42';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-37/42/59';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-4/10';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-40/41/71';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-41/64';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-41/64/71';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-41/64/72';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-44/47/65';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-45/51';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-47/48';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-47/75';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-49/69';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-5/8';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-50/53';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-55/91';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-56/60';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-59/62/75';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-61/70/74/76';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-61/74';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-66/95';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-7/9';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-70/76';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-77/110';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-80/95';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-83/99';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-84/92';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-85/116/117';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-86/87/97/108/119/125';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-87/115';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-88/91';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-90/101';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-90/101/113';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-93/95/98/100/102';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='PCB-aroclor 1242/1248/1254';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Chloroaniline';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p-Chloro-m-cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Chlorophenyl methyl sulfide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Chlorophenyl phenyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Chlorophenylacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p-Chlorotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p-Cresol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Dichlorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Penicillin G sodium';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentachloro-1,3-butadiene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Pentachloronitrobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Pentachlorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Pentachlorophenol dehydroabietylamine salt';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentacosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentadecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentadecanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentadecylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentafluorobenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Pentafluorophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pentanal';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,1 from di_characteristic c
 where c.display_name='Periphyton productivity';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Periphyton, substrate rock/bank encrustation (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Pesticide mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Ethyltoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Petroleum phenols';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Petroleum spirits';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenanthrene + anthracene(C1-C4) mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenol dehydroabietylamine salt';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenol, 2,6-dibromo-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenyl isocyanate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenylacetaldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phenylacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pheophytin a';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Phosmet';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Hydroxybenzoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Hydroxycinnamic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Phytoactin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,1 from di_characteristic c
 where c.display_name='Phytoplankton productivity';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Picloram';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Picloram triethylamine salt';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Picloram triisopropanolamine salt';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Picloram-isooctyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Picloram-potassium';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pinacolone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Piperonyl butoxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Isopropenylacetophenone';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Plutonium-239/240 mix, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Methoxyphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Nitroanisole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Nonylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,8 from di_characteristic c
 where c.display_name='Polychlorinated biphenyls';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Polycyclic aromatic hydrocarbons';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Polyethylene glycol mono-tert-butylphenyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Potassium permanganate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Phenylenediamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Quaterphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Precipitation, time since event';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Pregna-1,4-diene-3,20-dione, 11,17,21-trihydroxy-6-methyl-, (6.alpha.,11.beta.)-';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Primary productivity';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Productivity, photosynthetic rate, carbon production';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Profenofos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Prometon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Propanenitrile';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Propiconazole';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Propionic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Propoxyphene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Propyl acetate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Propyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Propylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Propylthiouracil';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Prothiofos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-tert-Butylbenzoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='p-tert-Butylphenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Toluidine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='p-Xylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Pyrazon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Radioactivity, gross';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bank Stability, Left (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bank Stability, Right (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bank Vegetative Protection, Left (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bank Vegetative Protection, Right (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bank Vegetative Stability, Left (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bank Vegetative Stability, Right (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Bottom Substrate (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Canopy Cover (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Channel Alteration (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Channel Flow Status (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Channel Sinuosity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Channelized Y/N (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Embeddedness (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Epifaunal Substrate (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Frequency of Riffles (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP High water mark';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Instream Cover (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Local Watershed Erosion (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Local Watershed NPS Pollution (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Pool Substrate (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Pool Variability (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Predominant Surrounding Land Use (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Sediment Deposition (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Sediment Odors (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Sediment Oils (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Stream depth - pool';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Stream Type (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Stream width';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Substrate - Gravel 2-64 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Substrate - Sand 0.06-2.0 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Turbidity Code (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Undersides of Loose Stones Black Y/N (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Water Odors (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP Water Surface Oils (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Aquatic Vegetation, Dominant Type & Species (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Aquatic vegetation, portion of reach with AV (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, bedrock (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, canopy (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, general comments';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, gravel-cobble (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, large woody debris (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, other (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, plants, roots (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, pools (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, riffle (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, run (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, sand (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, sand-silt-mud-muck (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, small woody debris (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, snags (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, submerged macrophytes (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Habitat type, vegetated banks (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Bank Stability, Left Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Bank Stability, Right Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Channel Alteration (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Channel Flow Status (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Embeddedness (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Epifaunal Substrate/Available Cover (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Frequency of Riffles (or bends) (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, habitat assessment total score';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Riparian Vegetative Zone Width, Left Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Riparian Vegetative Zone Width, Right Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Sediment Deposition (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Vegetative Protection, Left Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Vegetative Protection, Right Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, High G, Velocity/Depth Regime (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream Features, Canopy Cover (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream Features, Channelized (Y/N) (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream Features, Dam Present (Y/N) (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, est. reach length';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, est. stream depth';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, est. stream width';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, high water mark';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, morphology, pools (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, morphology, riffles (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, morphology, run (%)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, sampling reach area';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, surface velocity (at thalweg)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Instream features, total reach area';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Large woody debris, density of LWD (LWD/reach area)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Large woody debris, LWD (m2)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Bank Stability, Left Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Bank Stability, Right Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Channel Alteration (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Channel Flow Status (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Channel Sinuosity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Epifaunal Substrate/Available Cover (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, habitat assessment total score';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Pool Substrate Characterization (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Pool Variability (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Riparian Vegetative Zone Width, Left Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Riparian Vegetative Zone Width, Right Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Sediment Deposition (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Vegetative Protection, Left Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Low G, Vegetative Protection, Right Bank (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Riparian Vegetation, Dominant Species Present (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Sediment/Substrate, Deposits (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Sediment/Substrate, Embedded Stone Undersides Black (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Sediment/Substrate, Odors (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Sediment/Substrate, Oils (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Stream character, catchment area';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Stream Character, Stream Origin (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Stream Character, Stream Subsystem (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Stream Character, Stream Type (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, inorganic, bedrock';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, Inorganic, boulder, >256 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, inorganic, clay, <0.004 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, inorganic, cobble, 64-256 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, inorganic, gravel, 2-64 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, inorganic, sand, 0.06-2.0 mm';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, organic, detritus, sticks, wood, etc. (CPOM)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, organic, marl, grey shell fragments';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Substrate, organic, muck-mud, black-fine (FPOM)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Water Quality, Turbidity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Water Quality, Water Odors (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Water Quality, Water Surface Oils (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Watershed, Local Erosion (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Watershed, Local NPS Pollution (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Watershed, Predominant Surrounding Landuse (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, weather condition, general observation (text)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Weather Condition, Heavy Rain in Last 7 Days, Y/N (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Weather Condition, Now (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='RBP2, Weather Condition, Past 24 Hours (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Refined used lubricating oils';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='River/stream channel slope';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Sea waves severity (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='sec-Butylamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='sec-Butylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Secondary productivity';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Sediment, inorganic, classification (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Sediment, organic, classification (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Sethoxydim';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='S-Ethyl dipropylthiocarbamate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Settleable solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Shannon & Wiener  Macroinvert Taxonomic Diversity Index';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Silicate/dissolved inorganic nitrogen ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Silicon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Silvex isooctyl ester';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Simpson Taxonomic Diversity Index';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Simultaneously extracted metals';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Simultaneously extracted metals/acid volatile sulfides';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Sodium adsorption ratio [(Na)/(sq root of 1/2 Ca + Mg)]';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Sodium C14-16-alkane hydroxy and C14-16-olefin sulfonates';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Sodium cacodylate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Sodium chromate(VI)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Sodium methyldithiocarbamate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Stearonitrile';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Stigmastan-3.beta.-ol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Stream physical appearance (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Stream recreational suitability (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Stream stage';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Strontium 86/87 ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Strontium-Yttrium-90, beta';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='Substrate - submerged vegetation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,2 from di_characteristic c
 where c.display_name='Substrate-bedrock';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Sucrose';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Sulfate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Sulfite';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Sulfotep';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Sulprofos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Sum of anions';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Sum of cations';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Syringaldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tau-fluvalinate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Terbuthylazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Terphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='tert-Amyl methyl ether';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='tert-Amylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='tert-Butanol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='tert-Butylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetrabutyltin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetrachloro-1,3-butadiene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetrachloroguaiacol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tetrachlorvinphos (mixed isomers)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetracosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetradecane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetradecylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tetradifon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetraethyl ammonium hydroxide';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tetraethyl pyrophosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetrahydropyran';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetramethylpyrazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetratetracontane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tetrodotoxin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Thermal discharge';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Thidiazuron';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Thifensulfuron-methyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Thiophanate ethyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Thiophenol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Thorium-232';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tin-San';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Toluene diisocyanate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Toluene-d8';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Toluenediamine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Toluic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Total dissolved solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Total fixed solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Total nonfecal coliform';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Total solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Total suspended solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Total volatile solids';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, A. abdita, coefficient of variation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, A. verrilli, coefficient of variation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, E. estuarius, coefficient of variation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, L. plumulosus, coefficient of variation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, R. abronius, coefficient of variation';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, sediment, Ampelisca abdita, significant (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, sediment, Ampelisca verrilli, significant (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, sediment, Eohaustorius estuarius, significant (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,1 from di_characteristic c
 where c.display_name='Toxicity, sediment, L.plumulosus, control survival';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, sediment, Leptocheirus plumulosus, significant (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, sediment, microtox, Vibrio fischeri, significant (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,5 from di_characteristic c
 where c.display_name='Toxicity, sediment, Rhepoxynius abronius, significant (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Toxicity, water, 100%/ LC50 (% effluent) for Ceriodaphnia';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Toxicity, water, Ceriodaphnia dubia, LC50';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='trans-1,2-Cyclohexanediol';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='trans-1,2-Dichloroethylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='trans-1,4-Dichloro-2-butene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='trans-2-Methylcrotonaldehyde';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='trans-2-Phenyl-2-butene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='trans-Chlordane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='trans-Nonachlor';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Triacontane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Triadimefon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Triazines mixture, unspecified';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tribromomethane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tribufos';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tributlytin';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tributyl phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tributyltin chloride';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tricalcium phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Tricamba';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Trichlorfon';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trichloro-1,3-butadiene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Trichloroacetic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trichlorobiphenyl';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tricosane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trihalomethanes';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Triisopropyl orthoborate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trimethylbenzene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trimethylcyclohexene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trimethylpyrazine';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Trinitrotoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tris(2-butoxyethyl) phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tris(2-chloroethyl) phosphate';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Tritriacontane';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='True color';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Undecanoic acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,11 from di_characteristic c
 where c.display_name='Uranium-238';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Valeric acid';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Velocity-discharge';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Vinyltoluene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Water';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Water level in well during pumping, MSL';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Water level in well, MSL';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Weather comments (text)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,10 from di_characteristic c
 where c.display_name='Weather condition (WMO code 4501) (choice list)';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Wood creosote';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Xanthacridinum';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,9 from di_characteristic c
 where c.display_name='Xylene';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,7 from di_characteristic c
 where c.display_name='Nitrogen, ammonium/ammonia ratio';

insert into characteristic_chartype cc (fk_characteristic,fk_chartype)
 select pk_isn,6 from di_characteristic c
 where c.display_name='Organic Nitrogen';


--1483 rows selected.

-- following are WQX characteristics with chr_storet_id null;


insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '.beta.-Sitosterol';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '1,3,4,6,7,8-Hexahydro-4,6,6,7,8,8-hexamethylcyclopenta[g]-2-benzopyran';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '2-(Nonylphenoxy)ethanol';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '2-[2-[4-(1,1,3,3-Tetramethylbutyl)phenoxy]ethoxy]ethanol';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '2-[4-(1,1,3,3-Tetramethylbutyl)phenoxy]ethanol';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '5-Tolyltriazole';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = '6-Acetyl-1,1,2,4,4,7-hexamethyltetralin';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 6 from di_characteristic c where display_name = 'Ammonia-nitrogen';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Ammonium';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 9 from di_characteristic c where display_name = 'Cacodylic acid';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Chloramines mixture, unspecified';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Coprosterol';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 10 from di_characteristic c where display_name = 'Detergent, severity (choice list)';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Diethylene glycol nonylphenol ether';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 10 from di_characteristic c where display_name = 'Floating solids or foam';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 2 from di_characteristic c where display_name = 'Lloyd - Zar - Karr Species Diversity Index';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Methyldibenzothiophene';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 6 from di_characteristic c where display_name = 'Nutrient-nitrogen';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 6 from di_characteristic c where display_name = 'Organic phosphorus';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 10 from di_characteristic c where display_name = 'Particle size';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'p-Cumylphenol';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 6 from di_characteristic c where display_name = 'Phosphate-phosphorus';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Polybrominated biphenyls';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 6 from di_characteristic c where display_name = 'Polyphosphate';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 2 from di_characteristic c where display_name = 'Residence/flushing time, waterbody';
insert into characteristic_chartype (fk_characteristic, fk_chartype)  select c.pk_isn, 7 from di_characteristic c where display_name = 'Tris(1,3-dichloro-2-propyl)phosphate';

commit;

set feedback on;
set echo off;

prompt Count of characteristic_chartype;
select count(*) from characteristic_chartype;

prompt OVERALL characteristics without chartype assignment


select count(*) from di_characteristic c
where not exists (select 1 from characteristic_chartype cc
    where cc.fk_characteristic = c.pk_isn);

prompt WQX characteristics without chartype assignment
select count(*) from di_characteristic c
where not exists (select 1 from characteristic_chartype cc
    where cc.fk_characteristic = c.pk_isn)
and pk_isn >= 1000000;


spool off;


